using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Security.Cryptography;
using System.Text;
using UnityEngine;

public class ZOEncoding
{
	// Cl secrte utilise pour le chiffrement (32 caractres pour AES-256)
	private static readonly string secretKey = "Z86UmwzJNnuPaP8YWfUxlh0bqLttkkVa";

	// Chiffre une chane de caractres avec AES
	public static string Encoder(string text)
	{
		if (string.IsNullOrEmpty(text)) return string.Empty;

		using (Aes aesAlg = Aes.Create())
		{
			// Gnration du vecteur d'initialisation (IV)
			aesAlg.GenerateIV();
			byte[] iv = aesAlg.IV;

			// Configuration de la cl et du mode de chiffrement
			aesAlg.Key = Encoding.UTF8.GetBytes(secretKey);
			aesAlg.Mode = CipherMode.CBC;
			aesAlg.Padding = PaddingMode.PKCS7;

			// Chiffrement
			using (var encryptor = aesAlg.CreateEncryptor(aesAlg.Key, iv))
			using (var msEncrypt = new MemoryStream())
			{
				// Ajoute le IV au dbut du message chiffr pour le dchiffrement
				msEncrypt.Write(iv, 0, iv.Length);

				using (var csEncrypt = new CryptoStream(msEncrypt, encryptor, CryptoStreamMode.Write))
				using (var swEncrypt = new StreamWriter(csEncrypt))
				{
					swEncrypt.Write(text);
				}

				return Convert.ToBase64String(msEncrypt.ToArray());
			}
		}
	}

	// Dchiffre une chane de caractres chiffre avec AES
	public static string Decoder(string encodedText)
	{
		if (string.IsNullOrEmpty(encodedText)) return string.Empty;

		byte[] cipherTextCombined = Convert.FromBase64String(encodedText);

		using (Aes aesAlg = Aes.Create())
		{
			// Rcupration du IV  partir du message chiffr
			byte[] iv = new byte[aesAlg.BlockSize / 8];
			byte[] cipherText = new byte[cipherTextCombined.Length - iv.Length];
			Array.Copy(cipherTextCombined, iv, iv.Length);
			Array.Copy(cipherTextCombined, iv.Length, cipherText, 0, cipherText.Length);

			// Configuration de la cl et du mode de chiffrement
			aesAlg.Key = Encoding.UTF8.GetBytes(secretKey);
			aesAlg.IV = iv;
			aesAlg.Mode = CipherMode.CBC;
			aesAlg.Padding = PaddingMode.PKCS7;

			// Dchiffrement
			using (var decryptor = aesAlg.CreateDecryptor(aesAlg.Key, aesAlg.IV))
			using (var msDecrypt = new MemoryStream(cipherText))
			using (var csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
			using (var srDecrypt = new StreamReader(csDecrypt))
			{
				return srDecrypt.ReadToEnd();
			}
		}
	}
}
